
/*
 * Copyright (c) 2006-2007 by Roland Riegel <feedback@roland-riegel.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef FAT16_CONFIG_H
#define FAT16_CONFIG_G

/**
 * \addtogroup fat16
 *
 * @{
 */
/**
 * \file
 * FAT16 configuration.
 */

/**
 * \ingroup fat16_config
 * Controls FAT16 write support.
 *
 * Set to 1 to enable FAT16 write support, set to 0 to disable it.
 */
#define FAT16_WRITE_SUPPORT 1

/**
 * \ingroup fat16_config
 * Maximum number of filesystem handles.
 */
#define FAT16_FS_COUNT 1

/**
 * \ingroup fat16_config
 * Maximum number of file handles.
 */
#define FAT16_FILE_COUNT 1

/**
 * \ingroup fat16_config
 * Maximum number of directory handles.
 */
#define FAT16_DIR_COUNT 2

/**
 * @}
 */

#endif

